#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Funky SwirlsMod01.fsh  by  domizai  
//https://www.shadertoy.com/view/....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
    Inspired by wnu's 'chocolate swirl': https://www.shadertoy.com/view/NtcSDs
    and combined with: https://www.shadertoy.com/view/fl3XDs
*/

#define RATIO iResolution.x / iResolution.y
#define POINTS 15
#define FORCE 3. // the larger the smaller the swirl
#define ROTATION 9.
#define PI 3.141592653589793


float n21 (vec2 p)
{
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}


vec2 n22 (vec2 p)
{
    float n = n21(p);
    return vec2(n, n21(p+n));
}


mat2 rotate (float a) 
{
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}


vec3 diffuseLight (vec2 uv, vec3 normals, vec3 pos, vec3 col)
{
    vec3 dif = pos - vec3(uv, 0.); // point light
    //vec3 dif = pos; // directional light
    vec3 dir = normalize(dif);
    float intensity = 1. / length(dif); // inverse square law
    float diffuse   = dot(normals, dir) * intensity;
    return col * diffuse;
}


vec3 getHeight (vec2 uv, inout float acc_frc, inout vec2 acc_rot)
{
    float tm = iTime * .1;
        
    for (int i = 0; i < POINTS; i++)
    {
        float n = n21(vec2(i + 1));
        vec2 pnt = vec2(.5) + vec2(cos(tm + n * 423.1) * .6, sin(tm + n * 254.3) * .3);

        vec2  loc = uv - pnt;
        float len = length(loc);
        float frc = exp(len * -FORCE);
        float swl = frc * ROTATION * sin(tm + n * 624.8); 
        vec2  rot = loc * rotate(swl);
        
        uv = rot + pnt;
        
        acc_frc += frc;
        acc_rot += rot * frc; 
    } 
    
    float h = cos(uv.x + uv.y + 1.) * .5 + .5;
    
    return vec3(uv, h);
}


vec3 getHeight (vec2 p)
{
    float f = .0; vec2  r = vec2(0.);
    return getHeight(p, f, r);
}


vec3 getNormal (vec2 p)
{
    vec2 eps = -vec2(1. / iResolution.y, .0);
    
    vec3 a = vec3(eps.xy, getHeight(p + eps.xy).z - getHeight(p - eps.xy).z);
    vec3 b = vec3(eps.yx, getHeight(p + eps.yx).z - getHeight(p - eps.yx).z);
    vec3 n = normalize(cross(a, b));

    return n;
}


vec3 offsetLights (vec2 uv, vec3 normals)
{
    float tm  = iTime * 1.;
    float off = .2; // offset
    float sth = .7; // strength
    float amb = .2; // ambient
    float rad = 1.; // radius
    vec3 pos  = vec3(.5, .5, 1.);
    
    float o2 = 1. * off;
    float o3 = 2. * off;
    
    vec3 p1 = vec3(pos.x + cos(tm) * rad, pos.y + sin(tm + 0.) * rad, pos.z);
    vec3 p2 = vec3(pos.x + cos(tm + o2) * rad, pos.y + sin(tm + o2) * rad, pos.z);
    vec3 p3 = vec3(pos.x + cos(tm + o3) * rad, pos.y + sin(tm + o3) * rad, pos.z);
    
    vec3 l1 = diffuseLight(uv, normals, p1, vec3(sth, 0., 0.));
    vec3 l2 = diffuseLight(uv, normals, p2, vec3(0., sth, 0.));
    vec3 l3 = diffuseLight(uv, normals, p3, vec3(0., 0., sth));
    
    return l1 + l2 + l3 + amb;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord / iResolution.xy - .5) * vec2(RATIO, 1.) + .5;
    vec3 col = vec3(0.);
    float tm = iTime;
    
    float acc_frc = .0;
    vec2  acc_rot = vec2(0.);
    getHeight(uv, acc_frc, acc_rot);
    
    vec3 normal1   = normalize(vec3(acc_rot, acc_frc * .01)).yxz;
    vec3 normal2   = getNormal(uv);
    vec3 normal    = normal1 + normal2 * 1.5;
    
    vec3 diffuse   = offsetLights(uv, normal);
    vec3 specular  = smoothstep(.8, .95, diffuse);
    vec3 material  = vec3(.2, .15, .05);
    vec3 light     = diffuse + specular + material;
    
    //col = light;
    //col = normal;
    col = light + sin(light * PI) - light; // To make it a bit more interesting
    
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

